<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('first_name', 'last_name', 'email', 'password', 'telephone', 'role', 'county_id', 'city_id', 'profession', 'age', 'tc', 'about', 'lat', 'lng', 'status');
    protected $hidden = array('password');

    public function city()
    {
        return $this->belongsTo('App\Models\City', 'city_id');
    }

    public function county()
    {
        return $this->belongsTo('App\Models\County', 'county_id');
    }

    public function services()
    {
        return $this->hasMany('App\Models\Service', 'user_id');
    }

    public function messages()
    {
        return $this->hasMany('App\Models\UserMessage', 'user_id');
    }

    public function uploads()
    {
        return $this->hasMany('App\Models\UserUpload', 'user_id');
    }

    public function source()
    {
        return $this->belongsTo('App\Models\Source', 'user_id');
    }

    public function ratings()
    {
        return $this->hasMany('App\Models\Rating', 'user_id');
    }

    public function notifications()
    {
        return $this->hasMany('App\Models\Notification', 'user_id');
    }

    public function serviceUploads()
    {
        return $this->hasMany('App\Models\ServiceCategoryUpload', 'user_id');
    }

    public function deviceTokens()
    {
        return $this->hasMany('App\Models\UserDeviceToken', 'user_id');
    }

}